在变量声明中，AT代码将项目变量分配给设备树中配置的PLC的特定输入地址、输出地址或内存地址。您还可以在PLC配置中的设备I/O映射对话框中定义将变量赋值给某个地址。

**语法：**

 AT : ;

 : % ( )?

   
AT声明允许您为地址指定一个有意义的名称。您可以仅在一个位置(例如声明中)对输入或输出信号进行任何必要的更改，例如在声明处。

> 例如
> 
> | VAR wInput AT %IW0 : WORD; END\_VAR | 带有输入字地址信息的变量声明 |
> |---|---|
> | VAR xActuator AT %QW0 : BOOL; END\_VAR | 布尔变量声明  注意：对于布尔变量，如果没有指定单个位地址，则在内部分配一个字节。xActuator的变化将影响QX0.0到QX0.7的范围。 |
> | VAR xSensor AT IX7.5 : BOOL; END\_VAR | 布尔变量声明，显式指定单个位地址。在访问时，只读取输入的7.5位。 |
> | VAR xSensor AT IX\* : BOOL; END\_VAR | 对于地址规范，给出的是占位符\*，而不是内存位置。最后的地址规范在变量配置中完成。  注意：这在功能块中是可能的。 |

如果你将一个变量赋值给一个地址，请注意以下几点:

- 您不能写入放在输入端的变量。这将导致编译器错误。
- 您只能对局部变量和全局变量执行声明，而不能对POUs的输入/输出变量执行声明。
- 此外，AT声明不能用于持久变量列表。
- 如果对结构组件或函数块变量使用AT声明，则所有实例使用相同的内存。这就像在传统编程语言(如C语言)中使用静态变量一样。
- 结构的内存布局也取决于目标系统。

提示！

如果没有显式地指定单个位地址，那么布尔变量将按字节分配。

> 例如
> 
>   
> PROGRAM PLC\_PRG  
> VAR  
>  xVar AT %QW0 : BOOL;   
> END\_VAR
> 
> xVar := TRUE;  
>    
> 当写入变量xVar时，输出内存范围QX0.0到QX0.7受到影响。